; RexDump - hex dump memory browsing utility for Rex 6000
;
; C. Harris
; Version 1.0 - 4/6/2001 - ultra simple: just up/down scrolling, one screen at a time
; Version 1.1 - 4/7/2001 - added quick "jump 1000h" button
; Version 1.2 - 5/4/2001 - added command line: Go/Search/Database/Write
;

#include "RexDB.h"
#include "RexSys.h"
#include "RexDump.h"

	.org  $7f35

	.text "ApplicationName:Addin\r\n"
	.text "Rex Dump v1.2\r\n"
	.db 0
	.db 1,0,0,0

; Program "icon" : like a hexdump screen
.db $00,$00,$00,$00,$00 
.db $00,$00,$00,$00,$00 
.db $00,$00,$00,$00,$00 
.db $00,$00,$00,$00,$00 
.db $00,$00,$00,$00,$00 
.db $ff,$ff,$ff,$ff,$ff 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0f,$c1 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0f,$c1 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0f,$c1 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0f,$c1 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0f,$c1 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0f,$c1 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$0c,$01 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$aa,$00,$01 
.db $80,$00,$00,$00,$01 
.db $8c,$aa,$a8,$08,$21 
.db $80,$00,$00,$18,$51 
.db $8c,$aa,$80,$08,$21 
.db $80,$00,$00,$08,$41 
.db $8c,$aa,$00,$1d,$71 
.db $80,$00,$00,$00,$01 
.db $ff,$ff,$ff,$ff,$ff
.db $00,$00,$00,$00,$00 
.db $00,$00,$00,$00,$00 


; 8000: program start
        ld      sp,$ffff

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; rexdump - main message loop
;; paints a page of memory dump on screen, waits for user input,
;; acts accordingly
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
rexdump: ld      hl,$fff6
        add     hl,sp
        ld      sp,hl

        ld      hl,$f000	; start dumping @ f000 = addin 4K memory
        ld      (ptr),hl

dmpmore: call cls
	 ld	a,0
	ld	(ypxel),a	; y=0;

	ld	a,nrows
	ld	(rowcount),a	; rows = 15

rowloop: 	ld      a,$20
        	ld      (xpxel),a	; x=0

		ld	a,ncols
		ld	(colcount),a	; cols = 8

; Display address HI BYTE:
		ld	hl,(ptr)
		ld	l,h
		ld		h,$00		; HL = byte to display
		push	hl
		ld		de,$0000	; DE = x
		ld		a,(ypxel)
		ld		c,a
		ld		b,$00		; BC = y
		push	bc
		call	DsPrtnumh
		pop		hl
		pop		hl

; Display address LO BYTE:
		ld	hl,(ptr)
		ld		h,$00		; HL = byte to display
		push	hl
		ld		de,$000c	; DE = x
		ld		a,(ypxel)
		ld		c,a
		ld		b,$00		; BC = y
		push	bc
		call	DsPrtnumh
		pop		hl
		pop		hl

colloop:	ld	hl,(ptr)
		ld		a,(hl)
		ld		l,a
		ld		h,$00		; HL = byte to display
		push	hl
		ld		a,(xpxel)	; DE = x
		ld		e,a
		ld		d,$00
		ld		a,(ypxel)
		ld		c,a
		ld		b,$00		; BC = y
		push	bc
		call	DsPrtnumh
		pop		hl
		pop		hl

		ld		a,(xpxel)	; x += 14
		add		a,$0e
		ld		(xpxel),a

		ld		hl,(ptr)
		inc		hl			; ptr++
		ld		(ptr),hl

		ld		a,(colcount)
		dec		a			; cols--
		ld		(colcount),a
		jr		nz,colloop		

; End of hex columns;  now paint "picture" characters:
		ld		a,(xpxel)	; x += 24  (gap before "picture")
		add		a,$18
		ld		(xpxel),a

		ld		hl,(ptr)
		ld		de,$0008		
		sbc		hl,de 	; ptr -= 8
		ld		(ptr),hl

		ld	a,8
		ld	(colcount),a	; cols = 8


pictloop:	ld		hl,(ptr)
		ld		a,(hl)
		ld		b,a

		ld		a,$1f
		cp		b	; char > $1f ?
		jr		nc,dot	; no, draw dot

		ld		a,$7d
		cp		b	; char > $7d ?
		jr		nc,pict	; no, draw character bmp

dot:		ld		b,'.'

; use DsPrtchar to show ASCII char.
pict:   	ld		l,b
		ld		h,$00		; HL = byte to display
		push	hl
		ld		a,(xpxel)	; DE = x
		ld		e,a
		ld		d,$00
		ld		a,(ypxel)
		ld		c,a
		ld		b,$00		; BC = y
		push	bc
		call	DsPrtchar
		pop		hl
		pop		hl

		ld		a,(xpxel)	; x += 8
		add		a,colwidth
		ld		(xpxel),a

		ld		hl,(ptr)
		inc		hl			; ptr++
		ld		(ptr),hl

		ld		a,(colcount)
		dec		a			; cols--
		ld		(colcount),a
		jr		nz,pictloop		


; All done with row, get ready for next one:
		ld		a,(ypxel)	; y += 8 (= 1 pixel between rows!)
						; y+=10 is a little easier on eyes
		add		a,rowwidth
		ld		(ypxel),a

		ld		a,(rowcount)
		dec		a
		ld		(rowcount),a
		jr		z,pagedone
		jp		rowloop

; end of page:	

pagedone:	nop


;;
;;
;; Wait for input
;;
;;
;	DsReadMessage($mog,1);
waitkey: ld      hl,$0001
        push    hl
        inc     hl
        add     hl,sp
        ld      c,l
        ld      b,h
        ld      de,$003a
        call    SYSCALL3
        pop     af


;	switch(mog.message){

;	case MSG_DS_PAINT:								
;		return;
;		break;
;       ld     hl,$0000
	ld hl,$0003
        add     hl,sp

        ld      c,(hl)
        inc     hl
        ld      b,(hl)


        ld      a,$01	; home key
        xor     c
        or      b
        jp      z,exit
 
ckup:   ld      a,$08	; up key
        xor     c
        or      b
        jp      nz,ckdown

	  ld	    hl,(ptr)
	ld	de,$00f0
ckup1:  sbc	    hl,de
	  ld	    (ptr),hl		
	  jp	    dmpmore

nomove: ld	hl,(ptr)
	ld	de,$0078
	jr	ckup1

ckdown: ld      a,$10	; down key
        xor     c
        or      b
        jp      z,dmpmore


ckback: ld      a,$02	; back key - for now = JUMP 1000h
        xor     c
        or      b
        jp      nz,ckselect

	  ld	    hl,(ptr)
        ld	de,$1000-$78
	  add     hl,de
	  ld	    (ptr),hl		
	  jp	    dmpmore


ckselect:  ld   a,$04	; "select" key - "goto", via keybd
        xor     c
        or      b
        jp      nz,nokey

	ld	hl,0
	ld	(parm1),hl
	ld	a,h
	ld	(parm2),a
	ld	(parm3),a
	ld	(parm4),a

        ld      hl,$000c	; max strlen + 1
        push    hl
        ld      hl,addrstr	; where to store input
;	ld	(hl),0		; "NIL" last input string!
        push    hl
        ld      hl,$0301	; "fn code": GetKboard
        push    hl
        call    SYSCALLEX
        pop     af
        pop     af
        pop     af

; First character of input string is command
	  ld	    hl,addrstr
	  ld	    a,(hl)
	cp	0
	jp	z,nokey		
	ld	(cmdchar),a	; save command char.

; convert input string to hex address:
; char 1 (MS nybble)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,nokey		
	call	htoi
	ld	b,a
	sla	b	; put in B, HI nybble
	sla	b
	sla	b
	sla	b   

; char 2
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,nokey		
	call	htoi
      add	a,b	; combine w/ HI nybble
	ld	b,a	; B = HI BYTE

; char 3
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,nokey		
	call	htoi
      ld	c,a
	sla	c	; put in C, HI nybble
	sla	c
	sla	c
	sla	c  

; char 4
	inc	hl
	  ld	    a,(hl)
	cp	0
	jp	z,nokey		
	  call    htoi
        add	a,c	; combine w/ HI nybble
	ld	c,a	; C = LO BYTE
	ld	(parm1),bc

; char 5 (if any)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,docmd		
	call	htoi
	ld	b,a
	sla	b	; put in B, HI nybble
	sla	b
	sla	b
	sla	b   

; char 6 (if any)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,docmd		
	call	htoi
      add	a,b	; combine w/ HI nybble
	ld	(parm2),a

; char 7 (if any)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,docmd		
	call	htoi
	ld	b,a
	sla	b	; put in B, HI nybble
	sla	b
	sla	b
	sla	b   

; char 8 (if any)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,docmd		
	call	htoi
      add	a,b	; combine w/ HI nybble
	ld	(parm3),a

; char 9 (if any)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,docmd		
	call	htoi
	ld	b,a
	sla	b	; put in B, HI nybble
	sla	b
	sla	b
	sla	b   

; char 10 (if any)
	inc	hl
	ld	a,(hl)
	cp	0
	jp	z,docmd		
	call	htoi
      add	a,b	; combine w/ HI nybble
	ld	(parm4),a

; Now examine specified command character
docmd: ld	a,(cmdchar)
	cp	'g'
	jr	z,gocmd
	cp	'G'
	jr	nz,othercmd

; Command is 'g' = GOTO:
gocmd: ld	bc,(parm1)
	 ld	(ptr),bc	; save as new DUMP ADDRESS
	jp	dmpmore

othercmd: cp	's'
	jr	z,srchcmd
	cp	'S'
	jr	nz,othercmd2

; Command is 's' = SEARCH:
srchcmd: ld	bc,(parm1)
	ld	hl,(ptr)
	ld	de,$0076	; Start at current displayed "page" +2 bytes
				; so we skip current match (if any)
	sbc	hl,de
	ld	(ptr),hl

srch0: ld	a,(hl)
	cp	b		; first byte match?
	jr	nz,srch1
	inc	hl
	ld	a,(hl)
	cp	c		; yes, 2nd byte match?
	jr	nz,srch2

; we found matching 2 bytes:  display, starting here
match: dec	hl
	ld	(ptr),hl
	jp	dmpmore

srch1: inc	hl
srch2: ld	a,(ptr)	; see if we hit limit:
	 cp	l		; are we back to our start addr?
	 jr	nz,srch0
	ld	a,(ptr+1)
	cp	h
	jr	nz,srch0
; yep, we're back where we started: BYTES NOT FOUND
	dec	hl		; undo 2-byte offset
	dec	hl
	ld	(ptr),hl
	call	notfound
	jp	nokey
;	jp	dmpmore	; just re-display current page

othercmd2: cp	'd'
	jr	z,dbcmd
	cp	'D'
	jp	nz,othercmd3


; experiments:
; open database!
dbcmd:  ld	de,(parm1)
; pass 2 byte value = dbcode (10000 = bmp, etc.)
	call	dbOpen

; This works:
	ld      de,(DbHandle)
     call    DbGetCnt	 ; DbGetRecordCount
     ld      ($f0f0),hl
     ld      ($f0f2),bc

	ld	hl,$0000	; record # (hi word)
	push	hl
	ld	a,(parm2)	; record # (lo word) counter (1 byte)
	ld	l,a
	push	hl
	ld	hl,$0001
	push	hl
	push	hl
	ld	de,(DbHandle)
	push	de
	call	DbFindRec	; DbFindRecord
	pop	af
	pop	af
	pop	af
	pop	af
	pop	af

	ld	($f0f8),hl	; save return

	ld	de,$f100	; buffer


; 
; read fields all at once:
;
;	ld	a,$ff
;	ld	(de),a
;	inc	de
;	ld	(de),a	; default to -1 result	
;	dec	de
	push de	; ? address of result = record ID
	ld	h,$00
	ld	a,(parm3)
	ld	l,a
;	ld	hl,$0001	; field 1
	push	hl
	ld	hl,(DbHandle)
	push	hl
	call	DbReadFld	; DbReadField
	pop	af
	pop	af
	pop	af
	ld	($f0fa),hl

; ... I deleted "field dump" for now

;skipflds: nop
;	ld	de,(DbHandle)
;	call	DbNextRec	; DbNextRecord
;	ld	($f0f4),hl

;	ld	de,$f110
;	push de	; ? address of result = record ID

;	ld	h,$00
;	ld	a,(parm3)
;	ld	l,a
;	ld	hl,$0001
;	push	hl
;	ld	hl,(DbHandle)
;	push	hl
;	call	DbReadFld	; DbReadField
;	pop	af
;	pop	af
;	pop	af
;	ld	($f0f6),hl

;	inc	de
;	inc	de
;	ld	a,e
;	cp	20		; = 10 x 2
;	jp	nz,dbgetrecs		

      call    dbClose
	jp	nomove
; (end of D/d command - database experiments)



othercmd3: cp	'w'
	jr	z,wcmd
	cp	'W'
	jp	nz,othercmd4


; "W" = write command
; Writes specified area of memory to database memo file
; max 32k bytes?
wcmd: call DbBeginTransaction
	ld	($f0f0),hl

	ld	de,DBID_MEMO
	call dbOpen
	ld	($f0f2),hl

		ld		hl,$0000		
        push    hl
        ld      hl,emptyStr
        push    hl
        ld      hl,addrstr	; use command string as filename!
        push    hl
        ld      hl,$0000
        push    hl
        push    hl
        ld      hl,(DbHandle)
        push    hl
        call    DbInsertRecord
		pop	af
		pop	af
		pop	af
		pop	af
		pop	af
		pop	af
	ld	($f0f4),hl

;        ex      de,hl
;        ld      hl,$000c
;        add     hl,sp
;        ld      sp,hl
;        ex      de,hl

;        ld      a,l
;        or      h
;        jr      z,l93d2                 ; (+$04)

;
; for 1K bytes dumped = 64 byte rows * 16 rows
; = (128+2)*16 = 2080 data bytes per file 
; Oops;  for memos, size = #lines!
	    ld      hl,16
        push    hl
        ld      hl,$0004	; MEMO_DATASIZE fld# = 4 
        push    hl
        ld      hl,(DbHandle)
        push    hl
        call    DbUpdateField
        pop     af
        pop     af
        pop     af
;        ld      a,l
;        or      h
;        jr      z,l9416                 ; (+$05)
	ld	($f0f6),hl

	ld	hl,0
	ld	(woffset),hl

	ld	bc,(parm1)	; use input parameter 1 as mem pointer - UPDATED WHILE WRITING

	ld	hl,buffer
	  ld	e,16	; 16 rows

wloop1: ld	d,64	; 64 bytes/row

; Row loop:  create an ASCII string of 64 bytes = 128 char.	
wloop2: ld	a,(bc)
	srl	a
	srl	a
	srl	a
	srl	a	; get hi nybble
	add	a,'0'
	cp	'9'+1
	jr	c,wl1
	add	a,7
wl1:	ld	(hl),a	; store ascii char
	inc	hl

	ld	a,(bc)
	and	$0f	; get lo nybble
	add	a,'0'
	cp	'9'+1
	jr	c,wl2
	add	a,7
wl2:	ld	(hl),a	; store ascii char
	inc	hl
	inc	bc
	dec	d
	jr	nz,wloop2
	
	ld	(hl),$0d
	inc	hl
	ld	(hl),$0a
	inc	hl

	dec	e
	jp	nz,wloop1	; go do another row

	ld	(hl),0	; terminate string

        ld      hl,buffer
        push    hl
        ld      hl,130*16	; # characters (including CRLF)
        push    hl

	ld		hl,0
;	ld	    hl,(woffset)	; offset  (where in DB record to write data)
        push    hl
        ld      bc,MEMO_TEXT	; field #
        ld      de,(DbHandle)
        call    DbInsertText
        pop     af
        pop     af
        pop     af
	ld	($f0f8),hl

;	ld	a,(woffset)
;	inc	a
;	ld	(woffset),a	; offset for next write

;	ld	hl,(woffset)
;	ld	de,130	; hmm; maybe offset is # rows, not # bytes?
;	add	hl,de
;	ld	(woffset),hl	; offset for next write



	call dbClose

	ld	bc,0
	ld	de,1
	call DbEndTransaction

	jp	nomove

othercmd4: cp	'l'
	jr	z,loadcmd
	cp	'L'
	jr	nz,othercmd5


; Command is 'l' = LOAD:
loadcmd: ld	bc,(parm1)
	ld	a,(parm2)
	ld	(bc),a
	jp	nomove


othercmd5: cp	'b'
	jr	z,bankcmd
	cp	'B'
	jp	nz,othercmd6


; Command is "b" = bank
; experiment: 
bankcmd:  in      a,($01)	; A = current bank?
	ld	($f0ff),a		;  RETURNS 7Dh !  (bank #?)
	jp	nomove



othercmd6: .equ $
nokey:  jp		waitkey

;-----------------------

exit: ld      hl,$000a
        add     hl,sp
        ld      sp,hl

        ld	    de,$0042   ; DsAddinTerminate
	  call    SYSCALL1

;;
;; END OF rexdump loop 
;;



; integer multiply: BC x DE 
multiply:   push    af
        push    bc
        push    hl
        ld      hl,$0000

mult1:  srl     b
        rr      c
        jr      c,mult2                 ; (+$0a)

        ld      a,b
        or      c
        jr      z,mult3                 ; (+$0d)
 
        sla     e
        rl      d
        jr      mult1                   ; (-$10)
 
mult2:   add     hl,de
        sla     e
        rl      d
        jr      mult1                   ; (-$17)

mult3:   ex      de,hl
        pop     hl
        pop     bc
        pop     af
        ret     

; saveReg()
; from de-compiled C code; saves registers and initializes IX to stack
; at beginning of "lib" functions, then jumps indirect via HL
saveReg: pop     hl
        push    bc	; B: (IX+4)  C: (IX+5)
        push    de	; D: (IX+2)  E: (IX+3)
        push    ix
        ld      ix,$0000
        add     ix,sp
        jp      (hl)
 
; restoreReg()
; restores registers at end of "lib" functions
restoreReg:  ld      sp,ix
        pop     ix
        pop     de
        pop     bc
        ret   

; from de-compiled C code; saves registers and initializes IX to stack,
; allocating NNNN bytes on stack; then jumps indirect via HL
; Immediately following the "call saveRegAlloc" is a 16-bit
; stack offset, typically FFF0-FFFE, which specifies (negative) 
; space to allocate.
saveRegAlloc:  pop     hl		; HL = ret addr.
        push    bc
        push    de
        push    ix
        ld      ix,$0000
        add     ix,sp
        ld      e,(hl)		; get NNNNlo
        inc     hl
        ld      d,(hl)		; get NNNNhi
        inc     hl
        ex      de,hl		
        add     hl,sp		; adjust SP according to NNNN
        ld      sp,hl
        ex      de,hl
        jp      (hl)
  
; when returning from calls which use saveRegAlloc: 
saveRegAllocret:  ld      sp,ix
        pop     ix
        pop     de
        inc     sp
        inc     sp
        ret     

fnB:    ld      hl,$fff6
        add     hl,sp
        ld      sp,hl
        ld      de,$0030
        call    SYSCALL1


; DsDisplayBlockClear(0,0,240,120);
clear:  ld      hl,$0078
        push    hl
        ld      l,$f0
        push    hl
        ld      l,h
        push    hl
        call    blkclr
        pop     af
        pop     af
        pop     af


; Clear the specified rectangular area of screen
; DsDisplayBlockClear(x1,y1,x2,y2) {
blkclr: ld      c,l
        ld      b,h
	  ld      de,$0058
        jp      SYSCALL5


notfound: ld	hl,$0000
	push	hl
	ld	hl,nfstr
	push	hl
	ld	hl,$0020	; type
	push	hl
	ld	hl,$ffff
	push	hl
	ld	hl,$0080	; y
	push	hl
	ld	hl,$0020	; x
	push	hl
	ld	hl,$0330
	push	hl
	call SYSCALL3X
	pop	af
	pop	af
	pop	af
	pop	af
	pop	af
	pop	af
	pop	af
	ret


; Convert HEX ASCII character (0-9, a-f or A-F) 
; to INTEGER nybble (0-f)
htoi:	  sub	    $30	; 0-9 = 30-39h
	  cp	    $0a
	  jr	    c,htoidone

	  sub	    $07	; A-F = 41-46h = a-fh here
	cp	$10			
	jr	c,htoidone

	sub	$20		; a-f = 61-66h = a-fh here
	cp	$10
	jr	c,htoidone
	ld	a,$00		; Nope, garbage!
htoidone: ret



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; void DsPrtnumh(char x,char y,char z,int num){
;; ix+$2 = x
;; ix+$4 = y
;; ix+$6 = z???
;; ix+$a,$b = num
;; Display 2-digit hex #
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DsPrtnumh: call    saveReg
 

;DsDisplayBitmap(x,y,n[HI-NYBBLE],0);
        ld      hl,$0000
        push    hl

        ld      c,(ix+$0a)	; C = byte to disp
		srl	c				; get high nybble
		srl c
		srl c
		srl c

        ld      b,h
        ld      de,$000A	; x 10
        call    multiply
;  sla c
;  rl  b		; x 2
;  ld d,b
;  ld e,c 
;  sla c
;  rl  b		; x 4
;  sla c
;  rl  b		; x 8

        ld      hl,nbmp
        add     hl,de
;  add hl,bc
        push    hl
        ld      c,(ix+$04)	; BC = y
        ld      e,(ix+$02)	; DE = x?
        ld      d,b
        call    dispbmp
        pop     af
        pop     af


 ;DsDisplayBitmap(x+6,y,n[LO-NYBBLE],0);
        ld      hl,$0000
        push    hl

		ld  a,(ix+$0a)	; C =  lo nybble 
		and $0f
		ld	c,a

        ld      b,h
        ld      de,$000a	; x 10
        call    multiply
; sla c
; rl  b		; x 2
; ld d,b
; ld e,c 
; sla c
; rl  b		; x 4
; sla c
; rl  b		; x 8

        ld      hl,nbmp
        add     hl,de
;   add hl,bc  
        push    hl
        ld      c,(ix+$04)
        ld      e,(ix+$02)
        ld      d,b
        ld      hl,$0006
        add     hl,de
        ex      de,hl
dispbmpC:  call    dispbmp
        pop     af
        pop     af
        jp      restoreReg


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; void DsPrtchar(char x,char y,char z,int num){
;; Display single ASCII char
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DsPrtchar: call    saveReg

;DsDisplayBitmap(x,y,a[HI-NYBBLE],0);
        ld      hl,$0000
        push    hl

        ld      a,(ix+$0a)	; C = byte to disp
	ld	b,$20
	sub	b			; offset by $20
	  ld	    c,a
        ld      b,h
        ld      de,$000A	; x 10
        call    multiply
 ; sla c
 ; rl  b		; x 2
 ; ld d,b
 ; ld e,c 
 ; sla c
 ; rl  b		; x 4
 ; sla c
 ; rl  b		; x 8

        ld      hl,abmp
 ; add hl,bc  
        add     hl,de
        push    hl
        ld      c,(ix+$04)
        ld      e,(ix+$02)
        ld      d,b
        call    dispbmp
        pop     af
        pop     af
        jp      restoreReg

;;;;;;;;;;;;;;

;
; cls
; In Mogura, this function
; initialized coordinates of mole holes $ buttons,
; and paints them on the screen
; Now it just clears screen
; void cls(void){

cls:   push    bc
        push    de

;// Blank screen
;DsDisplayBlockClear(0,0,240,120);
        ld      hl,$0078
        push    hl
        ld      l,$f0
        push    hl
        ld      l,h
        push    hl
        call    blkclr
        pop     af
        pop     af
        pop     af
	  pop     de
        pop     bc
        ret     


miscA:  ld      b,h
miscA2: ld      de,$002c
        jp      SYSCALLh

miscB:   call    saveRegAlloc
	.dw	$fffc
	in	a,($04)		; INPUT port 4
        ld      (ix-$04),a
        in      a,($03)		; INPUT port 3
        ld      (ix-$03),a
        ld      de,$0030
        call    SYSCALL1
        ld      a,$10
        out     ($04),a		; OUTPUT port 4
        xor     a
        out     ($03),a		; OUTPUT port 3
        xor     a
        ld      (ix-$02),a
        ld      (ix-$01),a
  
miscB1: ld      bc,$8e10	; what is this?????????
        ld      l,(ix-$02)
        ld      h,(ix-$01)
        ld      a,$80
        xor     h
        ld      h,a
        sbc     hl,bc
        jr      nc,miscB3                ; (+$20)
        ld      l,(ix-$02)
        ld      h,(ix-$01)
        ld      a,$a0
        add     a,h
        ld      h,a
        xor     a
        ld      (hl),a
        inc     hl
        ld      (hl),a
        inc     hl
        ld      (hl),a
        inc     hl
        ld      (hl),a
        ld      hl,$0002
        add     hl,sp
        ld      a,(hl)
        add     a,$04
        ld      (hl),a
        jr      nc,miscB2                ; (+$02)
        inc     hl
        inc     (hl)
miscB2:  jr      miscB1                   ; (-$31)
 
miscB3: ld      a,(ix-$04)
        out     ($04),a		; OUTPUT port 4
        ld      a,(ix-$03)
        out     ($03),a		; OUTPUT port 3
        jp      restoreReg

SYSCALL1:  call    saveReg
        ld      ($c000),de
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg

SYSCALL2:  call    saveReg
        ld      ($c000),de
        ld      ($c002),bc
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg

SYSCALL3:   call    saveReg
        ld      ($c000),de
        ld      ($c002),bc
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        ld      ($c004),hl
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg


SYSCALL5:  call    saveReg
        ld      ($c000),de
        ld      ($c002),bc
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        ld      ($c004),hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        ld      ($c006),hl
        ld      l,(ix+$0c)
        ld      h,(ix+$0d)
        ld      ($c008),hl
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg

SYSCALL6:  call    saveReg
        ld      ($c000),de
        ld      ($c002),bc
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        ld      ($c004),hl
        ld      c,(ix+$0c)
        ld      b,(ix+$0d)
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        ld      ($c006),hl
        ld      ($c008),bc
        ld      l,(ix+$0e)
        ld      h,(ix+$0f)
        ld      ($c00a),hl
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg


SYSCALLh:  call    saveReg
        ld      ($c000),de
        ld      ($c002),bc
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        ld      ($c004),hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        ld      ($c006),hl
        ld      l,(ix+$0c)
        ld      h,(ix+$0d)
        ld      ($c008),hl
        ld      l,(ix+$0e)
        ld      h,(ix+$0f)
        ld      ($c00a),hl
        ld      l,(ix+$10)
        ld      h,(ix+$11)
        ld      ($c00c),hl
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg

SYSCALL3X:  call    saveRegAlloc
	.dw	$fffc
	ld	hl,$000c
        add     hl,sp
        ld      bc,$0002
        add     hl,bc
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0002
        add     hl,sp
        push    hl
        ld      c,(ix+$08)
        ld      b,(ix+$09)
        ld      de,$00ce
        call    SYSCALL3
        pop     af
        ld      (ix-$04),l
        ld      (ix-$03),h
        jp      restoreReg

; Display bitmap
dispbmp:  call    saveReg
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        push    hl
        in      a,($01)
        ld      l,a
        ld      bc,$0000
        ld      h,c
        ld      c,l
        ld      b,h
        ld      hl,$0000
        push    bc
        push    hl
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        ld      de,$0000
        pop     bc
        add     hl,bc
        ex      de,hl
        pop     bc
        adc     hl,bc
        push    hl
        push    de
        ld      l,(ix+$04)
        ld      h,(ix+$05)
        push    hl
        ld      c,(ix+$02)
        ld      b,(ix+$03)
        ld      de,$0072
        call    SYSCALL6		; 
        pop     af
        pop     af
        pop     af
        pop     af
        jp      restoreReg

miscJ:  call    saveReg
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        push    hl
        push    bc
        push    de
        ld      bc,$0003
        ld      de,$00f6
        call    SYSCALL5
        pop     af
        pop     af
        pop     af
        jp      restoreReg


SYSCALL4:  call    saveReg
        ld      ($c000),de
        ld      ($c002),bc
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        ld      ($c004),hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        ld      ($c006),hl
        rst     10h
        ld      hl,$c00e
        ld      b,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,b
        jp      restoreReg



SYSCALLEX:  call    saveRegAlloc
	.dw $fffc
	ld	hl,$000c
        add     hl,sp
        ld      bc,$0002
        add     hl,bc
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0002
        add     hl,sp
        push    hl
        ld      c,(ix+$08)
        ld      b,(ix+$09)
        ld      de,$00ce
        call    SYSCALL3	; l99f1
        pop     af
        ld      (ix-$04),l
        ld      (ix-$03),h
        jp      saveRegAllocret


; dbOpen() - opens database of specified record type
dbOpen:  push    de
;        ld      de,10000	; why doesn't it assemble this: DBIDPICTURE
;        ld      de,4000		; memos
        call    DsDbOpen
        ld      (DbHandle),hl
        pop     de
        ret     


; dbClose() - close database
dbClose:  push    de
        ld      de,(DbHandle)
        call    DsDbClose
        pop     de
        ret     


; "Ds"DbOpen - library call to open database w/ all files
; of specified type
DsDbOpen:  call    saveReg
        ld      c,e
        ld      b,d
        ld      de,$00d4
        call    SYSCALL2
        jp      restoreReg

; "Ds"DbClose - library call to close database
DsDbClose:  call    saveReg
        ld      c,e
        ld      b,d
        ld      de,$00d6
        call    SYSCALL2
        jp      restoreReg


; DbGetRecordCount
; returns # records of current type in database;
; or FF31 F3FF = ???? error return
DbGetCnt:  call    saveRegAlloc
	.dw	$fffc

	xor	a
        ld      (ix-$04),a
        ld      (ix-$03),a
        ld      (ix-$02),a
        ld      (ix-$01),a
        ld      hl,$0000
        add     hl,sp
        push    hl
        ld      c,(ix+$02)
        ld      b,(ix+$03)
        ld      de,$00ee
        call    SYSCALL3
        pop     af
        ld      c,(ix-$02)
        ld      b,(ix-$01)
        ld      l,(ix-$04)
        ld      h,(ix-$03)
        jp      saveRegAllocret




; DbFindRecord
DbFindRec:  call    saveRegAlloc
	.dw	$fffc
	ld	hl,$0010
	add     hl,sp
        ld      bc,$0002
        add     hl,bc
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0002
        add     hl,sp
        push    hl
        ld      c,(ix+$0c)
        ld      b,$00
        push    bc
        ld      c,(ix+$0a)
        ld      b,$00
        push    bc
        ld      c,(ix+$08)
        ld      b,(ix+$09)
        ld      de,$00e0
        call    SYSCALL5
        pop     af
        pop     af
        pop     af
        ld      (ix-$04),l
        ld      (ix-$03),h
        jp      restoreReg

; DbReadField
DbReadFld:  call    saveRegAlloc
	.dw	$fffc
	ld	hl,$000e
        add     hl,sp
        ld      bc,$0002
        add     hl,bc
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0002
        add     hl,sp
        push    hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        push    hl
        ld      c,(ix+$08)
        ld      b,(ix+$09)
        ld      de,$00de
        call    SYSCALL4
        pop     af
        pop     af
        ld      (ix-$04),l
        ld      (ix-$03),h
        jp      restoreReg


; DbNextRecord
DbNextRec:  call    saveReg
        ld      c,e
        ld      b,d
        ld      de,$00e2
        call    SYSCALL2
        jp      restoreReg

; DbReadText
DbReadTxt:  call    saveRegAlloc
	.dw	$fffa
	
	ld	l,(ix+$0c)
        ld      h,(ix+$0d)
        ld      (ix-$06),l
        ld      (ix-$05),h
        ld      (ix-$04),$01
        ld      (ix-$03),$00
        ld      l,(ix+$0e)
        ld      h,(ix+$0f)
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0000
        add     hl,sp
        push    hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        push    hl
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        push    hl
        push    bc
        ld      c,(ix+$02)
        ld      b,(ix+$03)
        ld      de,$00ea
        call    SYSCALL6
        pop     af
        pop     af
        pop     af
        pop     af
        jp      restoreReg


DbBeginTransaction:  push    bc
        push    de
        ld      bc,$0007
        ld      de,$00f6
        call    SYSCALL2
        pop     de
        pop     bc
        ret
		     
DbEndTransaction: call    saveReg
        ld      d,$00
        push    de
        ld      bc,$000b
        ld      de,$00f6
        call    SYSCALL3
        pop     af
        jp      restoreReg


DbUpdateField:  call    saveRegAlloc
	.dw	$fffc
	ld	hl,$000e
        add     hl,sp
        ld      bc,$0002
        add     hl,bc
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0002
        add     hl,sp
        push    hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        push    hl
        ld      c,(ix+$08)
        ld      b,(ix+$09)
        ld      de,$00e8
        call    SYSCALL4
        pop     af
        pop     af
        ld      (ix-$04),l
        ld      (ix-$03),h
        jp      restoreReg

DbInsertRecord:  call    saveRegAlloc
	.dw	$fffc
	ld	hl,$000c
        add     hl,sp
        ld      bc,$0002
        add     hl,bc
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0002
        add     hl,sp
        push    hl
        ld      c,(ix+$08)
        ld      b,(ix+$09)
        ld      de,$00d8
        call    SYSCALL3
        pop     af
        ld      (ix-$04),l
        ld      (ix-$03),h
        jp      restoreReg

DbInsertText:  call    saveRegAlloc
	.dw	$fffa
	xor	a 
       ld      (ix-$06),a
        ld      (ix-$05),a
        ld      (ix-$04),$02
        ld      (ix-$03),$00
        ld      l,(ix+$0c)
        ld      h,(ix+$0d)
        ld      (ix-$02),l
        ld      (ix-$01),h
        ld      hl,$0000
        add     hl,sp
        push    hl
        ld      l,(ix+$0a)
        ld      h,(ix+$0b)
        push    hl
        ld      l,(ix+$08)
        ld      h,(ix+$09)
        push    hl
        push    bc
        ld      c,(ix+$02)
        ld      b,(ix+$03)
        ld      de,$00ea
        call    SYSCALL6
        pop     af
        pop     af
        pop     af
        pop     af
        jp      restoreReg

nfstr: .text "Not Found!"
	.db $0d,$0a,0

emptyStr: .db 0

;  
; n[][]
nbmp: .db 6,8,$00,$70,$88,$88,$88,$88,$88,$70	; 0
	.db 6,8,$00,$10,$30,$10,$10,$10,$10,$38	; 1
	.db 6,8,$00,$70,$88,$08,$30,$40,$80,$f8	; 2
	.db 6,8,$00,$70,$88,$08,$30,$08,$88,$70	; 3
	.db 6,8,$00,$10,$30,$50,$90,$f8,$10,$10	; 4
	.db 6,8,$00,$f8,$80,$f0,$08,$08,$88,$70	; 5
	.db 6,8,$00,$70,$88,$80,$f0,$88,$88,$70	; 6
	.db 6,8,$00,$f8,$88,$08,$10,$20,$20,$20	; 7
	.db 6,8,$00,$70,$88,$88,$70,$88,$88,$70	; 8
	.db 6,8,$00,$70,$88,$88,$78,$08,$88,$70	; 9
	.db 6,8,$00,$20,$50,$88,$f8,$88,$88,$88	; A
	.db 6,8,$00,$f0,$88,$88,$f0,$88,$88,$f0	; B 
	.db 6,8,$00,$70,$88,$80,$80,$80,$88,$70	; C 
	.db 6,8,$00,$f0,$88,$88,$88,$88,$88,$f0	; D 
	.db 6,8,$00,$f8,$80,$80,$e0,$80,$80,$f8	; E 
	.db 6,8,$00,$f8,$80,$80,$e0,$80,$80,$80	; F 

; a[][] - ASCII character bitmaps, 0x20-0x7f
abmp: .db 6,8,$00,$00,$00,$00,$00,$00,$00,$00  ; sp 20
	.db 6,8,$00,$20,$20,$20,$20,$20,$00,$20  ; !  21 
	.db 6,8,$00,$50,$50,$00,$00,$00,$00,$00  ; "  22 
	.db 6,8,$00,$28,$50,$f8,$50,$f8,$50,$a0  ; #  23 
	.db 6,8,$00,$20,$50,$80,$60,$10,$50,$20  ; $  24 
	.db 6,8,$00,$20,$50,$20,$18,$d0,$28,$10  ; %  25 
	.db 6,8,$00,$38,$40,$40,$a0,$b0,$a0,$78  ; &  26 
	.db 6,8,$00,$20,$20,$00,$00,$00,$00,$00  ; '  27 
	.db 6,8,$00,$20,$20,$40,$40,$40,$20,$20  ; (  28 
	.db 6,8,$00,$40,$40,$20,$20,$20,$40,$40  ; )  29 
	.db 6,8,$00,$20,$20,$f8,$50,$88,$00,$00  ; *  2a 
	.db 6,8,$00,$00,$20,$20,$f8,$20,$20,$00  ; +  2b 
	.db 6,8,$00,$00,$00,$00,$00,$00,$20,$40  ; ,  2c 
	.db 6,8,$00,$00,$00,$00,$f8,$00,$00,$00  ; -  2d 
	.db 6,8,$00,$00,$00,$00,$00,$00,$00,$20  ; .  2e 
	.db 6,8,$00,$08,$10,$10,$20,$40,$40,$80  ; /  2f 

	.db 6,8,$00,$70,$88,$88,$88,$88,$88,$70	; 0 30
	.db 6,8,$00,$10,$30,$10,$10,$10,$10,$38	; 1
	.db 6,8,$00,$70,$88,$08,$30,$40,$80,$f8	; 2
	.db 6,8,$00,$70,$88,$08,$30,$08,$88,$70	; 3
	.db 6,8,$00,$10,$30,$50,$90,$f8,$10,$10	; 4
	.db 6,8,$00,$f8,$80,$f0,$08,$08,$88,$70	; 5
	.db 6,8,$00,$70,$88,$80,$f0,$88,$88,$70	; 6
	.db 6,8,$00,$f8,$88,$08,$10,$20,$20,$20	; 7
	.db 6,8,$00,$70,$88,$88,$70,$88,$88,$70	; 8
	.db 6,8,$00,$70,$88,$88,$78,$08,$88,$70	; 9 39
	.db 6,8,$00,$00,$00,$20,$00,$00,$20,$00  ; : 3a
	.db 6,8,$00,$00,$00,$20,$00,$00,$20,$40  ; ; 3b
	.db 6,8,$00,$00,$08,$30,$40,$30,$08,$00  ; < 3c
	.db 6,8,$00,$00,$00,$f8,$00,$f8,$00,$00  ; = 3d
	.db 6,8,$00,$00,$40,$30,$08,$30,$40,$00  ; > 3e
	.db 6,8,$00,$30,$48,$08,$10,$20,$00,$20  ; ? 3f

	.db 6,8,$00,$70,$88,$98,$a8,$98,$80,$70  ; @ 40
	.db 6,8,$00,$20,$50,$88,$f8,$88,$88,$88	; A 41
	.db 6,8,$00,$f0,$88,$88,$f0,$88,$88,$f0	; B 42
	.db 6,8,$00,$70,$88,$80,$80,$80,$88,$70	; C 
	.db 6,8,$00,$f0,$88,$88,$88,$88,$88,$f0	; D 
	.db 6,8,$00,$f8,$80,$80,$e0,$80,$80,$f8	; E 
	.db 6,8,$00,$f8,$80,$80,$e0,$80,$80,$80	; F 
	.db 6,8,$00,$70,$88,$80,$80,$98,$88,$70  ; G 
	.db 6,8,$00,$88,$88,$88,$f8,$88,$88,$88  ; H 
	.db 6,8,$00,$70,$20,$20,$20,$20,$20,$70  ; I 
	.db 6,8,$00,$38,$10,$10,$10,$90,$90,$60  ; J 
	.db 6,8,$00,$88,$90,$a0,$c0,$a0,$90,$88  ; K 
	.db 6,8,$00,$80,$80,$80,$80,$80,$80,$f8  ; L 
	.db 6,8,$00,$88,$d8,$d8,$a8,$a8,$88,$88  ; M
	.db 6,8,$00,$88,$c8,$c8,$a8,$98,$98,$88  ; N 
	.db 6,8,$00,$70,$88,$88,$88,$88,$88,$70  ; O 4F

	.db 6,8,$00,$f0,$88,$88,$f0,$80,$80,$80  ; P 50
	.db 6,8,$00,$70,$88,$88,$88,$98,$70,$08  ; Q 
	.db 6,8,$00,$f0,$88,$88,$e0,$90,$90,$88  ; R 
	.db 6,8,$00,$70,$88,$80,$70,$08,$88,$70  ; S 
	.db 6,8,$00,$f8,$20,$20,$20,$20,$20,$20  ; T
	.db 6,8,$00,$88,$88,$88,$88,$88,$88,$70  ; U 
	.db 6,8,$00,$88,$88,$88,$50,$50,$50,$20  ; V 
	.db 6,8,$00,$88,$88,$88,$a8,$a8,$a8,$50  ; W 
	.db 6,8,$00,$88,$50,$50,$20,$50,$50,$88  ; X 
	.db 6,8,$00,$88,$50,$50,$20,$20,$20,$20  ; Y 
	.db 6,8,$00,$f8,$08,$10,$20,$40,$80,$f8  ; Z 5A
	.db 6,8,$00,$70,$40,$40,$40,$40,$40,$70  ; [ 5B
	.db 6,8,$00,$80,$80,$40,$20,$20,$10,$10  ; \ 5C
	.db 6,8,$00,$70,$10,$10,$10,$10,$10,$70  ; ] 5D
	.db 6,8,$00,$20,$50,$88,$00,$00,$00,$00  ; ^ 5E
	.db 6,8,$00,$00,$00,$00,$00,$00,$00,$f8  ; _ 5F

	.db 6,8,$00,$40,$20,$10,$00,$00,$00,$00  ; ` 60
	.db 6,8,$00,$00,$00,$00,$68,$98,$98,$68  ; a 61
	.db 6,8,$00,$00,$80,$80,$b0,$c8,$c8,$b0  ; b 62
	.db 6,8,$00,$00,$00,$70,$88,$80,$88,$70  ; c 
	.db 6,8,$00,$00,$08,$08,$68,$98,$98,$68  ; d 
	.db 6,8,$00,$00,$00,$70,$88,$f8,$80,$78  ; e 
	.db 6,8,$00,$00,$18,$20,$78,$20,$20,$20  ; f 
	.db 6,8,$00,$00,$68,$98,$98,$68,$08,$70  ; g 
	.db 6,8,$00,$00,$80,$80,$b0,$c8,$88,$88  ; h 
	.db 6,8,$00,$00,$20,$00,$20,$20,$20,$20  ; i
	.db 6,8,$00,$00,$10,$00,$30,$10,$10,$e0  ; j 
	.db 6,8,$00,$00,$80,$90,$a0,$c0,$a0,$90  ; k 
	.db 6,8,$00,$00,$20,$20,$20,$20,$20,$20  ; l 
	.db 6,8,$00,$00,$00,$d0,$a8,$a8,$a8,$a8  ; m 
	.db 6,8,$00,$00,$00,$b0,$c8,$88,$88,$88  ; n 
	.db 6,8,$00,$00,$00,$70,$88,$88,$88,$70  ; o 6F

	.db 6,8,$00,$00,$00,$b0,$c8,$c8,$b0,$80  ; p 70
	.db 6,8,$00,$00,$68,$98,$98,$68,$08,$08  ; q 
	.db 6,8,$00,$00,$00,$b0,$c0,$80,$80,$80  ; r 
	.db 6,8,$00,$00,$00,$78,$80,$70,$08,$f0  ; s 
	.db 6,8,$00,$20,$20,$f8,$20,$20,$20,$20  ; t
	.db 6,8,$00,$00,$00,$88,$88,$88,$98,$68  ; u 
	.db 6,8,$00,$00,$00,$88,$88,$50,$50,$20  ; v 
	.db 6,8,$00,$00,$00,$88,$88,$a8,$a8,$50  ; w
	.db 6,8,$00,$00,$00,$88,$50,$20,$50,$88  ; x 
	.db 6,8,$00,$00,$00,$88,$50,$20,$40,$80  ; y 
	.db 6,8,$00,$00,$00,$78,$10,$20,$40,$78  ; z 7A
	.db 6,8,$00,$10,$20,$20,$40,$20,$20,$10  ; { 7B
	.db 6,8,$00,$20,$20,$20,$00,$20,$20,$20  ; | 7C
	.db 6,8,$00,$20,$10,$10,$08,$10,$10,$20  ; } 7D
	.db 6,8,$00,$00,$00,$00,$68,$b0,$00,$00  ; ~ 7E
	.db 6,8,$00,$00,$00,$00,$00,$00,$00,$00  ;   7F

endprog: .end

; Rex Tools wouldn't accept the binary executable (.rex)
; calling it a TEXT file instead, until I added this padding:
;	defs 1000,$ff
