/*

	Rex 6000
	SunMoon
	written by Davrex

	version 0.1

*/

#include <rex/rex.h>
#include <stdlib.h> 
#include <string.h>

#define TRUE -1
#define FALSE 0

// Field numbers for memo records
#define MEMO_RECID	1	// 32 bit int - DB record #
#define MEMO_NAME	2	// varstr - Memo name
#define MEMO_X1	3	// 8 bit int = -1 (unknown)
#define MEMO_DATASIZE	4	// 16 bit int = size, in lines of text
#define MEMO_X2	5	// 32 bit int = 0 (unknown)
#define MEMO_TEXT	6	// text of the memo

// DbFindRecord "mode" parameter:
#define FIND_CURRENT	0	// If record not found, returns error
#define FIND_NEXT		1	// If record not found, returns next record
#define FIND_PREVIOUS	2	// If record not found, returns previous record


#define DBID_MEMO_LENINFO 4004

#define MEMOL_RECID		1	// Record ID
#define MEMOL_LINES		2	// # lines
#define MEMOL_CHARS		3	// # chars
#define MEMOL_LINELENS	4	// offset for each end-of-line

#define LEN_BUFFER 400

#define W_REX 	240
#define H_REX 	120
#define X_PLOT  90
#define H_PLOT	50
#define W_PLOT 75 // (W_REX-X_PLOT)/2
#define X_RESUM 165 // X_PLOT+W_PLOT
#define W_RESUM 75 // W_REX-X_RESUM

#define Y_PLOT_SUN 0
#define Y_PLOT_MOON 70 // H_REX-H_PLOT
#define DELTA_ONA 8
#define H_ONA 42 //H_PLOT-DELTA_ONA
#define SUN_HORIZON 25 //(DELTA_ONA+Y_PLOT_SUN+H_ONA)/2
#define MOON_HORIZON 95 //(DELTA_ONA+Y_PLOT_MOON+H_ONA)/2

#define ICON_SIZE 120 // 10*(10+12+12)
#define NUM_BASE 0
#define SIGN_BASE 0 //10*10
#define EVENT_BASE (10+12)*10

#define N_COL_GEN 20

#define ITEMS_ROUND 20
#define RAD_QUA ITEMS_ROUND*ITEMS_ROUND

char *IniFileName = "ZAstro1";
char *TEXTCOL = "MNARaRNRCRRiNoSeCSNSaSASmRmSmN";
char *SIGNES = "artagecnleviliessgcpacpi";
char *SEASONS = "Spring\0Summer\0Autumn\0Winter";
char pSeasons[]={0,0,0,7,7,7,14,14,14,21,21,21};
signed char txInc[]={20,0,0,0,-20,-20,-20,0,0,0,20,20};
signed char tyInc[]={0,13,13,13,0,0,0,-13,-13,-13,0,0};
int iIncMonth[]={0,306,337,0,31,61,92,122,153,184,214,245,275};
char iRound[]={20,20,20,20,20,19,19,19,18,18,17,17,16,15,14,13,12,11,9,6,0};
char iSFase[]={84,20,56,92,32,68,4,40,79,15,
	       51,87,26,62,98,34,74,10,46,82,
	       21,57,93,29,69,5,41,77,16,52,88};
char fHeight[]={12,12,12,12,12,12,12,12,14,12,11,10};
char iIcons[]={0x08,0x08,0x66,0x99,0x99,0x18,0x18,0x18,0x18,0x18,
	       0x08,0x08,0x24,0x42,0x3C,0x42,0x5A,0x42,0x24,0x18,
	       0x08,0x08,0x81,0x7E,0x24,0x24,0x24,0x24,0x7E,0x81,
	       0x08,0x08,0x3C,0x72,0x88,0xF0,0x0E,0x11,0x4E,0x3C,
	       0x08,0x08,0x3C,0x22,0x79,0x45,0x45,0x45,0x39,0x02,
	       0x08,0x08,0x56,0xAA,0x2A,0x2D,0x2D,0x2D,0x2A,0x07,
	       0x08,0x08,0x18,0x24,0x42,0x42,0x24,0xE7,0x00,0xFF,
	       0x08,0x08,0xAC,0x54,0x54,0x55,0x55,0x55,0x55,0x02,
	       0x08,0x08,0x07,0xC3,0x35,0x08,0x14,0x22,0xFF,0x01,
	       0x08,0x08,0xc1,0xbe,0x08,0x3c,0x62,0x42,0xc4,0x38,
	       0x08,0x08,0x20,0x71,0xDB,0x8E,0x24,0x71,0xDB,0x8E,
	       0x08,0x08,0x81,0x42,0x24,0x24,0xFF,0x24,0x42,0x81};

signed char fx[]={-100,-100,-99,-97,-94,-91,-88,-83,-78,-73,-67,-60,-54,-46,-39,-31,
	   -23,-15,-6,2,10,19,27,35,43,50,57,64,70,76,81,86,90,93,96,98,99,100,
	   100,99,98,96,93,90,86,81,76,70,64,57,50,43,35,27,19,10,2,-6,-15,-23,
	   -31,-39,-46,-54,-60,-67,-73,-78,-83,-88,-91,-94,-97,-99,-100,-100};


/****************************************
 ** global vars
 ****************************************/
	unsigned int iYear, iMonth, iDay, iHour, iMinute, iTotMinut;
	unsigned int iSavingHour;
	unsigned int iDiaIdus, iAny2000, iDia2000;
	unsigned int iPercFase;
	int iMin[30];
	int iItem[30], nItems;
	char sBuffer[410];
	char sLin[180], iWhereLin;
	unsigned char bGoOn, bMoreReads;
	int nLast, nLastBuffer, nOffSet, iLin;
	unsigned short DbHandle;
	unsigned int iDay2000Ini, iDay2000Fin, iBase, iRiseMin, iSetMin, iRiseMax, iSetMax;
	int yMax, yMin, yFact;
	int iMoonRise, iMoonSet, iRiseSun, iSetSun;
	char str[10], bMoon;
	signed char iSigne, iSigneRise;


enum {
    mMidNoon=1,
    mAstronRise,
    mAstAmatRise,
    mNauticalRise,
    mCivilRise,
    mSunRise,
    mNoon,
    mSunSet,
    mCivilSet,
    mNauticalSet,
    mAstAmatSet,
    mAstronSet,
    mMoonRise,
    mMoonSet,
    mMoonNoon,
    mSign,
    mMoonPhase,
    mNow
}

main() {

	InitData();
	InitScreen();
	if (OpenDB()) {
		DsDisplayWaitIconDraw(1);
		ReadData();
		DsDisplayWaitIconDraw(0);

		PintaSigns();
		PlotMoonPhase();
		PintaCol();
		// INIT SUN
		//Horizon Line
	    	DsDisplayLine (X_PLOT, SUN_HORIZON, W_PLOT, 0, 255);
		Plotea1Sun(iRiseMax, iSetMax, yMax, SUN_HORIZON, 2);
		Plotea1Sun(iRiseMin, iSetMin, yMin, SUN_HORIZON, 2);
		//
		PutSun();
		if (bMoon)
		  PutMoon();
		else
		  DsPrintf(95,MOON_HORIZON,32,"No Moon Data!");
	
		DsEventClear();

		DsPrintf(95,55,16,"SUN & MOON for REX v0.9");
	} else
		DsPrintf(95,55,16,"Memo Error");
	DbClose(DbHandle);
	anykey();
	DsDisplayBlockClear(0, 0, 240, 120);
	DsAddinTerminate();

}

PlotMoonPhase()
{
	char bIncreasing, iX, iAux, i;
	int  iFactor;

	if (iPercFase<50) {
	    bIncreasing=TRUE;
	    iFactor=25-iPercFase;
	} else {
	    bIncreasing=FALSE;
	    iFactor=75-iPercFase;
	}

	iFactor = 4 * iFactor;
	iX = X_RESUM + W_RESUM / 2;

	// Original black Circle
	for (i=0;i<=ITEMS_ROUND;i++) {
	    DsDisplayLine(iX-iRound[i], MOON_HORIZON - i, 2*iRound[i], 0, 255);
	    DsDisplayLine(iX-iRound[i], MOON_HORIZON + i, 2*iRound[i], 0, 255);
	}


    	// Phase ilumination...
	for (i=0;i<=ITEMS_ROUND;i++) {
            iAux = iRound[i] * iFactor / 100;
	    if (bIncreasing) {
		DsDisplayLine(iX + iAux, MOON_HORIZON - i, iRound[i] - 1 - iAux, 0, 0);
		DsDisplayLine(iX + iAux, MOON_HORIZON + i, iRound[i] - 1 - iAux, 0, 0);
	    } else {
		DsDisplayLine(iX - iRound[i] + 1, MOON_HORIZON - i, iRound[i] - 1 + iAux, 0, 0);
		DsDisplayLine(iX - iRound[i] + 1, MOON_HORIZON + i, iRound[i] - 1 + iAux, 0, 0);
	    }
	 }

	// Print phase percentage...
	itoa(str, iPercFase);
    	DsPrintf(X_RESUM + W_RESUM - 15, 110, 32, str);


}

PintaSigns()
{
	char i;
        int x, y, bRev;

	DsPrintf(X_RESUM+20,20,32,&SEASONS[pSeasons[iSigne]]);

	x= X_RESUM + 43; //x = X_RESUM + 3 + xInc * 2 'Es una constant...
        y=1;

        for (i=0;i<12;i++) {
	    bRev=0;
            if (i==iSigne) {
	        DsDisplayBlock(x-1, y-1, 10, 10, 1);
		bRev=1;
            }
            DsDisplayBitmapDraw(x, y, &iIcons[10*i], bRev);
	    x+=txInc[i];
	    y+=tyInc[i];
        }
}
PutMoon() 
{

    int meuY;
    //Horizon Line
    DsDisplayLine (X_PLOT, MOON_HORIZON, W_PLOT, 0, 255);
    meuY = iMoonSet-iMoonRise;
    meuY = 37 - meuY*5/192;
    meuY=myFx(meuY);
    yFact=18;
    Plotea1Sun(iMoonRise, iMoonSet, meuY, MOON_HORIZON, 1);

}

PutSun()
{

   int meuY;
    meuY = iSetSun-iRiseSun;
    meuY = 37 - meuY*5/192; //(1800 - meuY*5/4)/48;
    meuY = myFx(meuY); //fx[meuY];
       // itoa(str,iRiseSun); DsPrintf(200,55,32,str);
       // itoa(str,iSetSun); DsPrintf(220,55,32,str);
    Plotea1Sun(iRiseSun, iSetSun, meuY, SUN_HORIZON, 1);

}
int myFx(int x)
{
    int iret;
    if (x>75) x=150-x;
    if (x<0) x=-x;
    iret = fx[x];
    return iret;
}


Plotea1Sun(int dRise, int dSet, int YShift, int yHorizon, char iStep)
{
    int dNoon, dShiftX, x, y, i, iAux;
    int ipSigne;

    if (dRise<dSet)
	ipSigne=-1;
    else
	ipSigne=1;    
    dNoon = (dRise+dSet)/2;
    dShiftX = 10*(dNoon - 720)/192; // 'hours & pixels shifted
    for (i=0;i<=W_PLOT;i+=iStep) {
	x=i-dShiftX;
        y=myFx(x);
	y=yHorizon+ipSigne*(y-YShift)*yFact/100;
        DsDisplayPointSet(X_PLOT+i,y,1);
    }
    if (iStep==1) {
	x=10*iTotMinut/192;
	iAux=x-dShiftX;
	y=myFx(iAux);
	y=yHorizon+ipSigne*(y-YShift)*yFact/100;
	if (y>114) y=114;
	DsPrintf(X_PLOT+x-3,y-3,32,"O");
    }
}
ReadData()
{
	unsigned char iZona, bPending;
	int nLin, iAcum, iAux, iAux2, iMinUT;
	char iAnySigne;
	//unsigned long lFase;
	int iDSTStart, iDSTEnd, iValue, iMinSigne;
	unsigned char i,j;
	unsigned char zstr[10];
	unsigned int uiAux;
	char bAux;

	iAnySigne = iAny2000;
	if (iMonth<3) iAnySigne--;
	bGoOn=TRUE;
	bMoon=FALSE;
   	ReadLin(TRUE);

	while (bGoOn) {
	     if (sLin[0]==';') {
		iZona++;
		nLin=0; iAcum=0;
		bPending=TRUE;
	     } else {
		switch (iZona)
		{
		case 1: /* INIT */
                    iDay2000Ini = iUnCoded();
                    iDay2000Fin = iUnCoded();
                    iBase = iUnCoded();
		    iMinUT=iUnCoded();
                    iRiseMin = iUnCoded();
                    iSetMin = iUnCoded();
                    iRiseMax = iUnCoded();
                    iSetMax = iUnCoded();
		    yMax =iUnCoded();
		    yMin =iUnCoded();
		    yFact=iUnCoded(); //TEST
		    break;
		case 2: /* SUNDATA */
		    if (bPending) {
		    if (nLin==0)
			for (j=mAstronRise;j<=mAstronSet;j++)
			    iMin[j]=iUnCoded(); 
		    else {
			iAux=iUnCoded();
			if (iAcum+iAux<iDiaIdus) {
			    for (j=mAstronRise;j<=mAstronSet;j++) {
				iMin[j]+=iUnCoded();
			    }
			    iAcum+=iAux;
			} else {
                                iAux2 = (100*(iDiaIdus - iAcum) + 25*(iAny2000 % 4)) / iAux;
                                bPending = FALSE;
				for (j=mAstronRise;j<=mAstronSet;j++)
				    iMin[j]+=((iAux2 * iUnCoded()) / 100);
                                nItems=12;
				for (j=1;j<13;j++)
				   iItem[j]=j;

                                iRiseSun = iMin[mSunRise];
                                iSetSun = iMin[mSunSet];
				//iMin[mNoon]=(iRiseSun+iSetSun)/2; // ???
                                iMin[mMidNoon] = iMin[mNoon] - 720;
			}
		    }
		    }
		    break;
		case 3: /* DST */
                    iValue = iUnCoded(); 
                    iDSTStart = iUnCoded();
                    iDSTEnd = iUnCoded(); 
		    for (j=0;j<=iAny2000;j++)
			iAux=iValue+iUnCoded();
                    bAux = FALSE;
                    if (iDiaIdus > iAux)
                        bAux = TRUE;
                    else
                        if (iAux==iDiaIdus)
			    if (iHour>=iDSTStart)
				bAux=TRUE;
		    if (bAux)
			iSavingHour+=(iDSTEnd - iDSTStart);
		    break;
		case 4: /* SIGNS */
		    iTotMinut = (iHour - iSavingHour) * 60 + iMinute;
		    if (nLin==iAnySigne) {
			InsertaBox(mNow, iTotMinut); //Before moon that can be negative
			iSigne=-1;
			bAux=TRUE;
			while ((iSigne<12) && bAux) {
			    iValue=iUnCoded();
			    iMinSigne=iUnCoded();
			    if (iValue>iDia2000)
				bAux=FALSE;
			    else {
	 		        iSigne++;
				if (iValue==iDia2000) {
			    	    InsertaBox(mSign,iMinSigne);
				    iSigneRise=iSigne;
				    if (iMinSigne>iTotMinut) iSigne--;
				    bAux=FALSE;
				}
                            }
			}
			if (iSigne<0 || bAux)
			   iSigne=11;
		    }
		    break;
		case 5: /* MOONRISE */
		    if ((iDay2000Ini+nLin)==iDia2000) {
			iMoonRise = iUnCoded();
			iMoonSet=iUnCoded();
			InsertaBox(mMoonRise,iMoonRise);
			InsertaBox(mMoonSet,iMoonSet);
			bMoon=TRUE;
		        //itoa(zstr,iMoonRise); DsPrintf(130,55,32,zstr);
		        //itoa(zstr,iMoonSet); DsPrintf(170,55,32,zstr);
			bGoOn=FALSE;
		    }
		    break;
		}
		nLin++;
	     }
	     ReadLin(TRUE);	     
	}

	//I must add and substract 300 to trick the compiler to use both bytes when iTotMinut<256
	iPercFase=((unsigned int)149*iDiaIdus)/44+iSFase[iAnySigne]+((300+iTotMinut-300-iMinUT)/425);

	//If above line went out of limits, could use the following approach...
	//uiAux=0;
	//if (iDiaIdus>176) {
	//	iDiaIdus-=176; //176 days are almost 596 centlunations
	//	uiAux=96;
	//}
	//iPercFase=(149*iDiaIdus)/44+iSFase[iAnySigne]+iTotMinut/425+uiAux;
	iPercFase=iPercFase%100;



}

InsertaBox(kItem, iMinuts)
	int kItem, iMinuts;
{
    int i,j;
    char bGo;

    bGo=TRUE;
    i=1;
    while ((i<=nItems) && bGo)
	if (iItem[i]!=0)
	    if (iMin[i]>iMinuts)
		bGo=FALSE;
             else
		i++;
	else
	   i++;

    for(j=nItems;j>=i;j--) {
           iItem[j+1]=iItem[j];
	   iMin[j+1]=iMin[j];
    }
    iItem[i]=kItem;
    iMin[i]=iMinuts;
    if (nItems/2+1 >= i) i--;
    nItems++;
    //Simetrical
    i=nItems + 2 - i;
    for(j=nItems;j>=i;j--) {
        iItem[j+1]=iItem[j];
	iMin[j+1]=iMin[j];
    }
    nItems++;
    if (i > nItems) i=nItems;
    iItem[i]= 0; //Empty & simmetrical box
}

PintaCol()
{
    int x, y, xAmple, yAlt;
    int nHeight;
    int iSense, xShift, iPis, i;
    int iH, iM, iDif;
    int iAux;
    char iPos;
    char sNom[10];
    
    


    nHeight = (nItems / 2)+1;
    yAlt=fHeight[nHeight];
    x = 1;
    iPis = 1;
    for (i=1;i<=nItems;i++) {
	switch (iItem[i])
		{
		case mNoon:
                   xAmple = 88; //xBigAmple
                   xShift = 46; //xNormAmple + 3;
                   iPis = nHeight;
                   iSense = -1;
		   break;
            	case mMidNoon:
                   xAmple = 88; //xBigAmple;
                   iPis = i;
                   iSense = 1;
		   xShift=0;
		   break;
		default:
                   xAmple = 42; //xNormAmple;
                   xShift = 0;
	        }
        //Draw...
        y = H_REX - (yAlt + 1) * iPis;
        if (iItem[i]!=0) {
            if (iItem[i]!=mNow)
                DsDisplayBlock(x, y, xAmple, yAlt, 0);

	    if (iMin[i]<0)
		iMin[i]+=1440;
            iH = iMin[i] / 60;
	    iM = iMin[i] % 60; // iMin[i] - 60 * iH;
            iH += iSavingHour;
	    //if (iM<0) { iH+=23;iM+=60; }
	    strcpy(sNom,"Nw00h00");
	    if (iItem[i] < mSign) {
		iAux=iItem[i]*2-2;
		sNom[0]=TEXTCOL[iAux++];
		sNom[1]=TEXTCOL[iAux];
	    } else {
		if (iItem[i]==mSign) {
		  iAux=iSigneRise*2;
		  sNom[0]=SIGNES[iAux++];
		  sNom[1]=SIGNES[iAux];
		}
	    }
            iPos=2; if (iH<10) iPos++;
	    itoa(&sNom[iPos],iH);
            iPos=5; if (iM<10) iPos++;
	    itoa(&sNom[iPos],iM);
            sNom[4]='h';
            DsPrintf(x + 2, y+2, 32, sNom);
        }
        x+=xShift;
        iPis+=iSense;
    }
}


InitData()
{
	int time , k;
	int date[2];

	DsCalCurrentTime(date, &time);
	iDay=date[0] % 256; /* low byte is date */
	iMonth=date[0] / 256; /* high byte is month */
	iYear=date[1]; /* Year */
	iHour=time / 256; /* high byte is hour */
	iMinute=time % 256; /* low byte is minute */	

	// TEST: Comment in final version !!!
	// iDay=23; iMonth=3;iYear=2002;iHour=1;iMinute=5;
	// TEST !!!

	iDiaIdus=iDay+iIncMonth[iMonth]-1;
	iAny2000=iYear-2000;
	//iDia2000=iDiaIdus;
	if (iMonth>2)
	    iDia2000=iDiaIdus+59;
	else
	    iDia2000=iDiaIdus-iIncMonth[1];

	iDia2000=iDia2000 + iAny2000*365 + iAny2000/4 +2;
}

InitScreen()
{
    DsDisplayBlockClear (0, 0, W_REX, H_REX);
    //Linia vertical separadora timecolumn i grafic
    DsDisplayLine (X_PLOT, 0, 0, H_REX, 255);
    //Linia horitzontal separador sun & middle
    DsDisplayLine (X_PLOT, Y_PLOT_SUN + H_PLOT, W_REX - X_PLOT, 0, 255);
    //Linia horitzontal separadora middel & moon
    DsDisplayLine (X_PLOT, Y_PLOT_MOON, W_REX - X_PLOT, 0, 255);
    //Linia vertical final grafic
    DsDisplayLine (X_RESUM, 0, 0, H_PLOT, 255);
    DsDisplayLine (X_RESUM, Y_PLOT_MOON, 0, H_PLOT, 255);
}

ReadLin(bReset)
	unsigned char bReset;
{
	int lenret;
	
	if (bReset) iLin=0;
	while (sBuffer[nLast]!='$' && nLast<LEN_BUFFER) {
	    if (sBuffer[nLast]!='\r')
	       sLin[iLin++]=sBuffer[nLast];
	    nLast++;
	    //iLin++;
	} 

	if (nLast>=LEN_BUFFER) {
	    // Read new buffer
	    if (bMoreReads) {
	        if (DbReadText(DbHandle, MEMO_TEXT, nOffSet, LEN_BUFFER, &lenret, sBuffer)==0) {
		    bMoreReads= (lenret==LEN_BUFFER); // Have we read the expected characters ?
		    nOffSet+=LEN_BUFFER;
	            nLast=0;
	            ReadLin(FALSE);
                } else bMoreReads=FALSE;

	    } else bGoOn=FALSE;
	} else {
	    nLast++;
	    nLast++; //one to skip the $ and the next to skip the \r that will follow...
	    sLin[iLin]='\0'; //useful for debugging
	}
	iWhereLin=0;
}

int OpenDB()
{
	int ret;
	//unsigned long MemoId;
	//unsigned short nlines, nchars;
	//int i;
	char bError;
	char *ptr;

	strcpy(str, IniFileName);

	bMoreReads=TRUE;
	bError=FALSE;
	nLast=LEN_BUFFER+1;
	iLin=0;

	DbHandle = DbOpen(DBID_MEMO);

	if (!DbHandle) return FALSE;
	// TEST: Use the first FindRecord in real life, the second in emulator mode...
	ret = DbFindRecord(DbHandle ,MEMO_NAME, FIND_NEXT,str,0,0);
	//ret = DbFindRecord(DbHandle, MEMO_RECID, FIND_CURRENT, 1,0);
	if (ret!=1) return FALSE;

	// TEST: Comment this block
	DbReadField(DbHandle, MEMO_NAME, &ptr);
	    // VERIFY that the found file's name field = OUR INI FILE NAME
	if (strcmp(ptr, str) !=0) return FALSE;


	return TRUE;
}


anykey()
{
MSG msg;	
int flag=1;

DsEventClear();
while (flag) {
	DsEventMessageGet(msg);
	switch (msg.message) {
		case MSG_DS_CLOSE:
		case MSG_DS_KEY_DOWN:
		case MSG_DS_TOUCH_DOWN:
		case MSG_DS_COMMAND:
			flag=0;break;
		     }
	}

}
int iUnCoded()
{
    int iret=0;

    char pAux;
    pAux=sLin[iWhereLin];
    while ((pAux!='+') && (pAux!='-')) {
	iret=iret<<4;
	iret+=(pAux-64);
	pAux=sLin[++iWhereLin];
    }
    iWhereLin++;
    if (pAux=='-') iret=-iret;
   
    return iret;
}

/* String copy routine to copy part of a string, like a bad mid() function */
/* D. Riley*/
/* strcopyn(s1, s2, n, end_str)
char *s1, *s2;
int n, end_str;
{
	char *os1;
	int i;
	os1 = s1;
	for(i=1;i<=n;i++) { *s1++ = *s2++; }
	if (end_str) { *s1++='\0'; }
    return(os1);
} */


