#include <rex/rex.h>
#include <stdlib.h>

#include "imgview.h"
#include "buttons.h"

#define REG_BANK1_LO	0x01
#define REG_BANK1_HI	0x02
#define REG_BANK2_LO	0x03
#define REG_BANK2_HI	0x04

#define LINE_MAX	30

anykey() {
	int f = 1;
	MSG msg;
	while(f) {
		DsEventMessageGet(msg);
		switch (msg.message) {
			case MSG_DS_CLOSE:
			DsClearScreen();
			DsAddinTerminate();
			break;
			case MSG_DS_KEY_DOWN:
			case MSG_DS_TOUCH_DOWN:
			case MSG_DS_COMMAND:
			f=0;
			break;
	     	}
	}
}

main() {
	int dbhandle, flag = 1, quit = 1, result;
	char tempkey, *picture_name;
	char buffer[LINE_MAX], bank2hi, bank2lo;
	unsigned short ret_len;
	int i, j, temp;
	MSG msg;

	DsEventClear();
	DsClearScreen();

	//display intro
	DsDisplayBitmapDraw(32, 32, imgview, 0);
	DsPrintf(80, 32, 16, "ImageView");
	DsPrintf(80, 52, 0, "By David Elsing");
	DsDisplayBitmapDraw(0, 111, home, 0);
	DsPrintf(9, 111, 32, "exit");
	DsDisplayBitmapDraw(48, 111, back, 0);
	//DsPrintf(57, 111, 32, "none");
	DsDisplayBitmapDraw(96, 111, enter, 0);
	DsPrintf(105, 111, 32, "name");
	DsDisplayBitmapDraw(144, 111, up, 0);
	DsPrintf(153, 111, 32, "last");
	DsDisplayBitmapDraw(192, 111, down, 0);
	DsPrintf(201, 111, 32, "next");
	anykey();

	//get first image
	DbBeginTransaction();
	dbhandle = DsDbOpen(DBID_PICTURE);
	DbFindRecord(dbhandle, 1, 1, 0, 0);

	while(quit) {
		//draw the picture
		DsClearScreen();
		j = 120;
		temp = 0xa000;
		while(j--) {
			DbReadText(dbhandle, 3, 0x3e + 32 * j, 32, &ret_len, buffer);
			bank2hi = REGISTER_READ(REG_BANK2_HI);
			bank2lo = REGISTER_READ(REG_BANK2_LO);
			REGISTER_WRITE(REG_BANK2_HI, 0x10);
			REGISTER_WRITE(REG_BANK2_LO, 0x00);
			for(i = 0; i < LINE_MAX; i++)
				*(char *)(temp++) = buffer[i];
			REGISTER_WRITE(REG_BANK2_HI, bank2hi);
			REGISTER_WRITE(REG_BANK2_LO, bank2lo);
		}

		//get user input
		flag = 1;
		do {
			DsEventMessageGet(&msg);
			switch(msg.message) {
				case MSG_DS_KEY_DOWN:
				switch(msg.sCode) {
					case KEY_TOP_A:
					flag = 0;
					quit = 0;
					break;
					case KEY_ENTER_A:
					DbReadField(dbhandle, 2, &picture_name);
					DsDisplayBlockClear(0, 0, 240, 10);
					DsPrintf(0, 0, 32, picture_name);
					break;
					case KEY_UP_A:
					flag = 0;
					while(1) {
						result = DbPreviousRecord(dbhandle);
						if(result == DB_NO_MORE_RECORD)
							flag = 1;
						if(result == DB_NO_MORE_RECORD || result == 1)
							break;
					}
					break;
					case KEY_DOWN_A:
					case MSG_DS_TOUCH_DOWN:
					flag = 0;
					while(1) {
						result = DbNextRecord(dbhandle);
						if(result == DB_NO_MORE_RECORD)
							flag = 1;
						if(result == DB_NO_MORE_RECORD || result == 1)
							break;
					}
					break;
				}
				break;
				case MSG_DS_CLOSE:
				flag = 0;
				quit = 0;
				break;
			}
		} while(flag);
	}
	DsClearScreen();
	DbClose(dbhandle);
	DbEndTransaction(1, 0);
	DsAddinTerminate();
}
