#include <rex/rex.h>
#include <stdlib.h>

#include "snake.h"

#define RTC_SEC		0x30

#define TOP_KEY		0x01
#define BACK_KEY 	0x02
#define ENTER_KEY	0x04
#define UP_KEY	 	0x08
#define DOWN_KEY	0x10

#define	BLOCK_SIZE	10
#define OFFSET_X	1
#define OFFSET_Y	12
#define FIELD_X		23
#define FIELD_Y		10
#define MAX_LENGTH	256

MSG msg;
POINT p;

getkey() {
	return REGISTER_READ(REG_KI_DATA);
}

anytouch() {
	p.PointX = 255;
	DsTouchDataGet(p);
	if(p.PointX != 255)
		return(1);
	return(0);
}

IkSound(duration, frqlo, frqhi) int duration, frqlo, frqhi; 
{
	REGISTER_WRITE(REG_ALM,0);
	REGISTER_WRITE(REG_MLDALM,1);  //choose melody instead of alarmsound 
	REGISTER_WRITE(REG_MELFRQ_HI,frqhi);
	REGISTER_WRITE(REG_MELFRQ_LO,frqlo);
	REGISTER_WRITE(REG_MELODY,2);	// set command??
	REGISTER_WRITE(REG_MELODY,1);	// play command
	DsSleep(duration);
	REGISTER_WRITE(REG_MELODY,1);	// play command
	REGISTER_WRITE(REG_MLDALM,0);	// default to alarm sound (also used for screenclicks)
}

main() {
	int	loop, flag;
	char	tempkey, str[10];
	int	foodx, foody;
	int	dirx = 1, diry = 0, newx, newy;
	int	x[MAX_LENGTH], y[MAX_LENGTH], head = 0, tail, length = 3, increase;
	long	speed = 250, score = 0;
	
	//start addin
	DsEventClear();
	DsClearScreen();

	//init snake position
	for(loop = 0; loop < length; loop++) {
		x[loop] = FIELD_X / 2;
		y[loop] = FIELD_Y / 2 - loop;
	}
	
	//intro screen
	DsDisplayBitmapDraw(32, 32, snake, 0);
	DsPrintf(80, 32, 16, "Snake");
	DsPrintf(80, 52, 0, "By David Elsing");
	IkSound(16, 248, 0); 
	IkSound(2, 14, 0); 
	IkSound(2, 248, 0); 
	IkSound(2, 14, 0);
	while(!anytouch());
	DsClearScreen();
	
	//draw field
	DsPrintf(0, 0, 0, "Snake - by David Elsing");
	DsPrintf(176, 0, 0, "0");
	DsDisplayBlock(OFFSET_X - 1, OFFSET_Y - 1, FIELD_X * BLOCK_SIZE + 2, FIELD_Y * BLOCK_SIZE + 2, 0);
	
	//create food
	srand((unsigned int)(REGISTER_READ( RTC_SEC ) * REGISTER_READ( RTC_SEC )));

	do {
		flag = 0;
		foodx = (rand() / (32767 / FIELD_X + 1));
		foody = (rand() / (32767 / FIELD_Y + 1));
		for(loop = 0; loop < length; loop++)
			if(x[loop] == foodx && y[loop] == foody)
				flag = 1;
	} while(flag);
	DsDisplayBlock(foodx * BLOCK_SIZE + OFFSET_X, foody * BLOCK_SIZE + OFFSET_Y, BLOCK_SIZE, BLOCK_SIZE, 1);

	//start game
	while(1) {
		//get input
		for(loop=0; loop < speed; loop++) {
			p.PointX = 255;
			DsTouchDataGet(p);
			if (p.PointX != 255) {
				//left
				if(p.PointX < 64 && dirx != 1) {
					dirx = -1;
					diry = 0;
				}
				//right
				if(p.PointX > 176 && dirx != -1) {
					dirx = 1;
					diry = 0;
				}
				//up
				if(p.PointX >= 64 && p.PointX <= 176 && p.PointY < 32 && diry != 1) {
					dirx = 0;
					diry = -1;
				}
				//down
				if(p.PointX >= 64 && p.PointX <= 176 && p.PointY > 88 && diry != -1) {
					dirx = 0;
					diry = 1;
				}
			}
			tempkey = getkey();
			switch (tempkey) {
				case TOP_KEY:
				case BACK_KEY:
				case ENTER_KEY:
				case UP_KEY:
				case DOWN_KEY:
					DsClearScreen();
					DsAddinTerminate();
					break;
			}
		}

		//print snake
		tail = (head + length - 1) % length;
		DsDisplayBlockClear(x[tail] * BLOCK_SIZE + OFFSET_X, y[tail] * BLOCK_SIZE + OFFSET_Y, BLOCK_SIZE, BLOCK_SIZE);
		
		newx = x[head] + dirx;
		newy = y[head] + diry;
		
		head = tail;
		
		tail--;
		if(tail < 0)
			tail = length - 1;
			
		x[head] = newx;
		y[head] = newy;
		
		//wall collision detect	
		flag = 0;
		if(x[head] < 0 || y[head] < 0 || x[head] >= FIELD_X || y[head] >= FIELD_Y) {
			flag = 1;
		}
		//snake collision detect
		for(loop = 0; loop < length; loop++) {
			if(x[loop] == x[head] && y[loop] == y[head] && loop != head)
				flag = 1;
		}
		//gameover!
		if(flag == 1) {
			DsSleep(50);
			DsPrintf(72, 54, 16, "G A M E  O V E R");
			while(!anytouch());
			DsClearScreen();
			DsAddinTerminate();
		}
	
		DsDisplayBlock(x[head] * BLOCK_SIZE + OFFSET_X, y[head] * BLOCK_SIZE + OFFSET_Y, BLOCK_SIZE, BLOCK_SIZE, 1);
		
		//food collision detect
		if(x[head] == foodx && y[head] == foody) {
			do {
				flag = 0;
				foodx = (rand() / (32767 / FIELD_X + 1));
				foody = (rand() / (32767 / FIELD_Y + 1));
				for(loop = 0; loop < length; loop++)
					if(x[loop] == foodx && y[loop] == foody)
						flag = 1;
			} while(flag);
			DsDisplayBlock(foodx * BLOCK_SIZE + OFFSET_X, foody * BLOCK_SIZE + OFFSET_Y, BLOCK_SIZE, BLOCK_SIZE, 1);
			
			score += length * 10;
			increase = length / 4;
			if(increase == 0)
				increase = 1;

			for(loop = length; loop < length+increase; loop ++) {
				x[loop] = -10;
				y[loop] = loop;
			}
			length += increase;
			
			//print new score
			DsDisplayBlockClear(176, 0, 32, OFFSET_Y - 1);
			itoa(str, score);
			DsPrintf(176, 0, 0, str);
			IkSound(2, 14, 0);
		}
	}
}
